' Copyright 2007 BFF Design Ltd
'
' Ian Hopper (BFF Design Ltd) Aug 2007
' http://buggies.builtforfun.co.uk - email Ian@builtforfun.co.uk
'
' For DIY 3 DOF Motion Cockpit Signal Processor Unit
'
'=====================================================
' ReadPos.bas is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 3 of the License, or
' (at your option) any later version.
'
' ReadPos.bas is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
' GNU General Public License for more details.
'
' A copy of the GNU General Public License is included in this zip archive
' You can also see it at http://www.gnu.org/licenses/.
'====================================================
'
' Read 3 position demand bytes from serial input on pin0 and forward on to the 3
' DOF position-to-speed demand coverter chips. Both this 28X and the 18X chips
' must be using 4 MHz resonators
'
'
' PICAXE 28X Pin designations
'
'	Out7	Pitch position output demand pulse
'	Out6	Pitch data-ready
'	Out5	Pitch high for slow rate
'
'	Out4	Roll position output demand pulse
'	Out3	Roll data-ready
'	Out2	Roll high for slow rate
'
'	Out1	Heave position output demand pulse
'	Out0	Heave data-ready
'	Outc7	Heave high for slow rate
'
'	In2	Heave 18X pulse for ready to receive
'	In3	Roll 18X pulse for ready to receive
'	In4	Pitch 18X pulse for ready to receive	
'
'	In0	Data Serial Input from PC
'

'Variable Declarations

symbol	code = b0
symbol	pos1 = b1
symbol	pos2 = b2
symbol	pos3 = b3
symbol	ready = w3
symbol	pulselength1 = w4
symbol	pulselength2 = w5
symbol	pulselength3 = w6

'pos1 is the pitch DOF, pos2 the roll DOF and pos3 the heave DOF

'Set the start values

	dirsc = %10000000		'set pin c7 to be output pin for the heave DOF	

	switchoff 5
	switchoff 2
	switchoff portc 7
	
	switchoff 6
	switchoff 3
	switchoff 0
	

'Start of main loop

MainLoop:

'Read the data from serial port into input0 at 4800 baud into bytes 1 to 3 - execution will pause
'here untill string "AB" is received and four 8 bit bytes are read. This effectively causes the chip to
'cycle at the rate the PC sends data

	serin 0, N4800, ("AB") , code, pos1, pos2, pos3
	
'Calculate the required pulse lengths to set the position demands

	pulselength3 = pos3 * 1 MIN 0 MAX 255		'Heave demand
	pulselength3 = pulselength3 + 10
	
	pulselength1 = pos1 * 1 MIN 0 MAX 255	 	'for Pitch
	pulselength1 = pulselength1 + 10

	pulselength2 = pos2 * 1 MIN 0 MAX 255		'for Roll
	pulselength2 = pulselength2 + 10

	
'Write the data by sending pulses to the data pins - pulse length is proportional to position demand
'so pulse length is in range from 10 to 265 us*10 representing full right to full left DOF position
'ie pulse from 0.1 to 2.65 ms in length

'1st for the heave DOF

	if code = 4 or code = 5 then					'Set high/low speed flag
		switchon portc 7
	else
		switchoff portc 7
	end if
	
	switchon 0								'Set data ready pin high
	
	pulsin 2, 1, ready						'Wait for a pulse on pin 2 to transmit
	
	if ready > 10000 then getout					'exit if excessive delay from receiving chip
	
	pulsout 1, pulselength3						'transmit
	
	switchoff 0								'switch the data ready pin back off 


'2nd for the pitch DOF

	if code = 2 or code = 5 then					'Set the motion rate pin
		switchon 5
	else
		switchoff 5
	end if
	
	switchon 6								'Set data ready pin high
	
	pulsin 4, 1, ready						'Wait for a pulse on pin 4 to transmit
	
	if ready > 10000 then getout					'exit
	
	pulsout 7, pulselength1						'transmit
	
	switchoff 6								'Switch data ready low


'Last for the Roll DOF - this gets data last so sees most delay - but it still isn't much


	if code = 3 or code = 5 then
		switchon 2
	else
		switchoff 2
	end if
	
	switchon 3								'Set data ready pin high
	
	pulsin 3, 1, ready						'Wait for a pulse on pin 3 to transmit
	
	if ready > 10000 then getout					'exit
										
	pulsout 4, pulselength2						'transmit
	
	switchoff 3								'set data ready low


'Return to the beginning to wait for next data from PC

	goto MainLoop



'Exit if any pulsin times out
getout:

	End















